import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for clear and painted tiles
clear_color = 'lightgreen'
white_color = 'white'
black_color = 'black'

# Define the tile colors for the goal state
goal_tile_colors = {
    'tile_0-1': clear_color, 'tile_0-2': clear_color, 'tile_0-3': clear_color, 'tile_0-4': clear_color,
    'tile_1-1': white_color, 'tile_1-2': black_color, 'tile_1-3': white_color, 'tile_1-4': black_color,
    'tile_2-1': black_color, 'tile_2-2': white_color, 'tile_2-3': black_color, 'tile_2-4': white_color,
    'tile_3-1': white_color, 'tile_3-2': black_color, 'tile_3-3': white_color, 'tile_3-4': black_color,
    'tile_4-1': black_color, 'tile_4-2': white_color, 'tile_4-3': black_color, 'tile_4-4': white_color,
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        color = goal_tile_colors[tile_id]
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        text_color = 'black' if color == clear_color else 'white'
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color=text_color)

# Draw the robots at the bottom
robot_positions = {'robot1': (0.5, -0.5), 'robot2': (2.5, -0.5)}
robot_colors = {'robot1': white_color, 'robot2': black_color}

for robot, (x, y) in robot_positions.items():
    color = robot_colors[robot]
    circle = patches.Circle((x, y), 0.3, edgecolor='black', facecolor=color)
    ax.add_patch(circle)
    ax.text(x, y-0.2, robot, ha='center', va='center', fontsize=8, color='black' if color == white_color else 'white')
    ax.text(x, y-0.5, 'no constraints', ha='center', va='center', fontsize=8, color='black')

# Set limits and labels
ax.set_xlim(0, cols)
ax.set_ylim(-1, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='White Tile'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Black Tile'),
    patches.Circle((0, 0), 0.3, edgecolor='black', facecolor=white_color, label='Robot1 (White)'),
    patches.Circle((0, 0), 0.3, edgecolor='black', facecolor=black_color, label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_15.png', bbox_inches='tight')
plt.show()